/*
 * Decompiled with CFR 0.152.
 */
package catserver.server;

import catserver.server.entity.CraftCustomEntity;
import java.util.Locale;
import java.util.Map;
import net.minecraftforge.common.util.EnumHelper;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import net.minecraftforge.registries.GameData;
import org.apache.logging.log4j.Level;
import org.bukkit.Material;
import org.bukkit.block.Biome;
import org.bukkit.block.banner.PatternType;
import org.bukkit.craftbukkit.v1_12_R1.enchantments.CraftEnchantment;
import org.bukkit.craftbukkit.v1_12_R1.potion.CraftPotionEffectType;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.EntityType;
import org.bukkit.potion.PotionEffectType;

public class BukkitInjector {
    public static boolean initializedBukkit = false;

    public static void injectItemBukkitMaterials() {
        for (Map.Entry<nf, ain> entry : ForgeRegistries.ITEMS.getEntries()) {
            nf key = entry.getKey();
            ain item = entry.getValue();
            if (key.b().equals("minecraft")) continue;
            String materialName = key.toString().toUpperCase().replaceAll("(:|\\s)", "_").replaceAll("\\W", "");
            int itemId = ain.a((ain)item);
            Material material = Material.addMaterial(EnumHelper.addEnum(Material.class, materialName, new Class[]{Integer.TYPE, Integer.TYPE, Material.MaterialType.class}, new Object[]{itemId, item.j(), Material.MaterialType.MOD_ITEM}));
            if (material != null) {
                FMLLog.log(Level.DEBUG, "Injected new Forge item material %s with ID %d.", material.name(), material.getId());
                continue;
            }
            FMLLog.log(Level.DEBUG, "Inject item failure %s with ID %d.", materialName, itemId);
        }
    }

    public static void injectBlockBukkitMaterials() {
        for (Material material : Material.values()) {
            if (material.getId() >= 256) continue;
            Material.addBlockMaterial(material);
        }
        for (Map.Entry entry : ForgeRegistries.BLOCKS.getEntries()) {
            nf key = (nf)entry.getKey();
            aow block = (aow)entry.getValue();
            if (key.b().equals("minecraft")) continue;
            String materialName = key.toString().toUpperCase().replaceAll("(:|\\s)", "_").replaceAll("\\W", "");
            int blockId = aow.a((aow)block);
            Material material = Material.addBlockMaterial(EnumHelper.addEnum(Material.class, materialName, new Class[]{Integer.TYPE, Material.MaterialType.class}, new Object[]{blockId, Material.MaterialType.MOD_BLOCK}));
            if (material != null) {
                FMLLog.log(Level.DEBUG, "Injected new Forge block material %s with ID %d.", material.name(), material.getId());
                continue;
            }
            if (blockId < 256) {
                throw new RuntimeException("Can't inject Forge block material. Registry remap is not support! (level.dat is from the old version or corrupted)");
            }
            FMLLog.log(Level.DEBUG, "Inject block failure %s with ID %d.", materialName, blockId);
        }
    }

    public static void injectBiomes() {
        block0: for (Map.Entry<nf, anh> entry : ForgeRegistries.BIOMES.getEntries()) {
            String biomeName = entry.getKey().a().toUpperCase(Locale.ENGLISH);
            for (Biome biome : Biome.values()) {
                if (biome.toString().equals(biomeName)) continue block0;
            }
            EnumHelper.addEnum(Biome.class, biomeName, new Class[0], new Object[0]);
        }
    }

    public static void injectEntityType() {
        Map NAME_MAP = (Map)ReflectionHelper.getPrivateValue(EntityType.class, null, "NAME_MAP");
        Map ID_MAP = (Map)ReflectionHelper.getPrivateValue(EntityType.class, null, "ID_MAP");
        for (Map.Entry<String, Class<? extends vg>> entity : EntityRegistry.entityClassMap.entrySet()) {
            String name = entity.getKey();
            String entityType = name.replace("-", "_").toUpperCase();
            int typeId = GameData.getEntityRegistry().getID(EntityRegistry.getEntry(entity.getValue()));
            EntityType bukkitType = EnumHelper.addEnum(EntityType.class, entityType, new Class[]{String.class, Class.class, Integer.TYPE, Boolean.TYPE}, new Object[]{name, CraftCustomEntity.class, typeId, false});
            NAME_MAP.put(name.toLowerCase(), bukkitType);
            ID_MAP.put((short)typeId, bukkitType);
        }
    }

    public static void registerEnchantments() {
        for (Object enchantment : alk.b) {
            Enchantment.registerEnchantment(new CraftEnchantment((alk)enchantment));
        }
        Enchantment.stopAcceptingRegistrations();
    }

    public static void registerPotions() {
        for (Object effect : uz.b) {
            PotionEffectType.registerPotionEffectType(new CraftPotionEffectType((uz)effect));
        }
        PotionEffectType.stopAcceptingRegistrations();
    }

    public static void registerBannerPatterns() {
        Map PATTERN_MAP = (Map)ReflectionHelper.getPrivateValue(PatternType.class, null, "byString");
        for (avg bannerPattern : avg.values()) {
            PatternType patternType;
            String bannerPatternName = bannerPattern.name();
            String bannerPatterKey = bannerPattern.b();
            if (PatternType.getByIdentifier(bannerPatterKey) != null || (patternType = EnumHelper.addEnum(PatternType.class, bannerPatternName, new Class[]{String.class}, new Object[]{bannerPatterKey})) == null) continue;
            PATTERN_MAP.put(bannerPatterKey, patternType);
        }
    }
}

